/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CInternetSocket.cp,v 1.2 1999/10/26 02:03:52 jason Exp $
____________________________________________________________________________*/

#include <stdarg.h>

#include "pgpMem.h"

#include "CInternetSocket.h"


CInternetSocket::CInternetSocket()
	: mEndpointRef(nil), mCanceled(false)
{
	// Set up the binding address to default
	mBoundAddress.fAddressType = AF_INET;
	mBoundAddress.fPort = 0;
	mBoundAddress.fHost = 0;
}



CInternetSocket::~CInternetSocket()
{
}



	void
CInternetSocket::Close()
{
	if (mInCallback) {
		::OTCancelSynchronousCalls(mEndpointRef, kOTCanceledErr);
		mCanceled = true;
	} else {
		Cleanup();
		
		::OTUnbind(mEndpointRef);
		::OTCloseProvider(mEndpointRef);
		delete this;
	}
}



	void
CInternetSocket::Bind(
	const PGPSocketAddressInternet *	inAddress)
{
	mBoundAddress.fPort = inAddress->sin_port;
	mBoundAddress.fHost = inAddress->sin_addr.s_addr;
}



	void
CInternetSocket::DoBind(
	OTQLen	inQLen)
{
	OSStatus	err;
	TBind		theBind;
	
	theBind.addr.len = sizeof(mBoundAddress);
	theBind.addr.buf = (UInt8 *) &mBoundAddress;
	theBind.addr.maxlen = sizeof(mBoundAddress);
	theBind.qlen = inQLen;
	
	err = ::OTBind(	mEndpointRef,
					&theBind,
					&theBind);

	ThrowIfOTError(err);
}



	void
CInternetSocket::Cleanup()
{
}



	Boolean
CInternetSocket::IsReadable()
{
	Boolean		isReadable = false;
	size_t		numBytes;
	OTResult	result;

	result = ::OTCountDataBytes(mEndpointRef, &numBytes);

	if ((result == kOTNoError) && (numBytes > 0)) {
		isReadable = true;
	} else {
		result = ::OTLook(mEndpointRef);
		
		switch (result) {
			case T_DISCONNECT:
			case T_ORDREL:
			{
				isReadable = true;
			}
			break;
			
			
			case T_LISTEN:
			{
				if (IsListening()) {
					isReadable = true;
				}
			}
			break;
		}
	}
	
	return isReadable;
}




	Boolean
CInternetSocket::IsWriteable()
{
	OTResult	result = ::OTGetEndpointState(mEndpointRef);
	Boolean		isWriteable = false;
	
	switch (mSocketType) {
		case kPGPSocketTypeStream:
		{
			if (result == T_DATAXFER) {
				isWriteable = true;
			}
		}
		break;
		
		
		case kPGPSocketTypeDatagram:
		{
			if (result == T_IDLE) {
				isWriteable = true;
			}
		}
	}
	
	return isWriteable;
}



	Boolean
CInternetSocket::IsError()
{
	if (::OTLook(mEndpointRef) == T_DISCONNECT) {
		return true;
	} else {
		return false;
	}
}



	pascal void
CInternetSocket::NotifyProc(
	void *		contextPtr,
	OTEventCode	code, 
	OTResult	result,
	void *		cookie)
{
	(void) result;
	(void) cookie;
	
	if (code == kOTSyncIdleEvent) {
		((CInternetSocket *) contextPtr)->mInCallback = true;
		if (CallIdleEventHandler() != kPGPError_NoErr) {
			((CInternetSocket *) contextPtr)->Close();
		}
		((CInternetSocket *) contextPtr)->mInCallback = false;
	}
}



	void
CInternetSocket::ThrowIfOTError(
	OSStatus	inErr)
{
	if (inErr < 0) {
		if (inErr == kOTCanceledErr) {
			Close();
		} else if (inErr == kOTLookErr) {
			// Clean up on an unexpected look
			OTResult	result;
			
			result = ::OTLook(mEndpointRef);
			switch (result) {
				case T_DISCONNECT:
				{
					::OTRcvDisconnect(mEndpointRef, nil);
					ThrowPGPError_(kPGPError_SocketsNotConnected);
				}
				break;
				
				
				case T_LISTEN:
				{
					TEndpointInfo	info;
					TCall			call;
					InetAddress		address;
					UInt8 *			options;
					
					inErr = ::OTGetEndpointInfo(mEndpointRef, &info);
					if (inErr == kOTNoError) {
						options = (UInt8 *) ::NewPtr(info.options);
						call.addr.buf = (UInt8 *) &address;
						call.addr.maxlen = sizeof(address);
						call.opt.buf = options;
						call.opt.maxlen = (options == nil) ? 0 : info.options;
						call.udata.buf = nil;
						call.udata.maxlen = 0;
						
						inErr = ::OTListen(mEndpointRef, &call);
						if (inErr == kOTNoError) {
							::OTSndDisconnect(mEndpointRef, &call);
						}
						::DisposePtr((Ptr) options);
					}
					
					ThrowPGPError_(kPGPError_UnknownError);
				}
				break;
				
				
				case T_ORDREL:
				{
					::OTRcvOrderlyDisconnect(mEndpointRef);
					ThrowPGPError_(kPGPError_SocketsNotConnected);
				}
				break;
				
				
				case T_UDERR:
				{
					inErr = ::OTRcvUDErr(mEndpointRef, nil);
				}
				break;
			}
		}
		
		ThrowPGPError_(inErr);
	} else if (mCanceled) {
		Close();
		ThrowPGPError_(kOTCanceledErr);
	}
}



	void
CInternetSocket::GetSocketName(
	PGPSocketAddressInternet *	outName)
{
	OSStatus	err;
	TBind		theBind;
	InetAddress	theBoundAddress;
	
	pgpClearMemory(&theBind, sizeof(theBind));
	theBind.addr.buf = (UInt8 *) &theBoundAddress;
	theBind.addr.maxlen = sizeof(theBoundAddress);
	
	err = ::OTGetProtAddress(	mEndpointRef,
								&theBind,
								nil);
	ThrowIfOTError(err);
	if (theBind.addr.len == 0) {
		ThrowPGPError_(kPGPError_SocketsNotBound);
	}
	pgpClearMemory(outName, sizeof(PGPSocketAddressInternet));
	outName->sin_family = kPGPAddressFamilyInternet;
	outName->sin_port = theBoundAddress.fPort;
	outName->sin_addr.s_addr = theBoundAddress.fHost;
}



	void
CInternetSocket::IOControlSocket(
	SInt32		inCommand,
	UInt32 *	ioParam)
{
	switch (inCommand) {
		case kPGPSocketCommandGetUnreadData:
		{
			::OTCountDataBytes(mEndpointRef, ioParam);	
		}
		break;
	}
}
